<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Dtos\Common;

use Erlage\Photogram\Data\Dtos\AbstractDTO;
use Erlage\Photogram\Data\Dtos\Traits\TraitComplaintValidatorDTO;
use Erlage\Photogram\Data\Dtos\Traits\TraitComplaintTransformerDTO;

class NotificationsCountDTO extends AbstractDTO
{
    /**
     * to comply with DTO interface
     */
    use TraitComplaintValidatorDTO;
    use TraitComplaintTransformerDTO;

    const DTO_NAME = 'notifications_count_dto';

    /*
    |--------------------------------------------------------------------------
    | key map
    |--------------------------------------------------------------------------
    */

    const KEY_LIKE_COUNT = 'like_count';

    const KEY_COMMENT_COUNT = 'comment_count';

    const KEY_FOLLOW_COUNT = 'follow_count';

    const KEY_OTHER_COUNT = 'other_count';

    /*
    |--------------------------------------------------------------------------
    | data
    |--------------------------------------------------------------------------
    */

    /**
     * @var string
     */
    private $likeCount;

    /**
     * @var string
     */
    private $commentCount;

    /**
     * @var string
     */
    private $followCount;

    /**
     * @var string
     */
    private $otherCount;

    /*
    |--------------------------------------------------------------------------
    | setters
    |--------------------------------------------------------------------------
    */

    /**
     * @return static 
     */
    public function setLikeCount(string $likeCount)
    {
        $this -> likeCount = $likeCount;

        return $this;
    }

    /**
     * @return static 
     */
    public function setCommentCount(string $commentCount)
    {
        $this -> commentCount = $commentCount;

        return $this;
    }

    /**
     * @return static 
     */
    public function setFollowCount(string $followCount)
    {
        $this -> followCount = $followCount;

        return $this;
    }

    /**
     * @return static 
     */
    public function setOtherCount(string $otherCount)
    {
        $this -> otherCount = $otherCount;

        return $this;
    }

    /*
    |--------------------------------------------------------------------------
    | from json
    |--------------------------------------------------------------------------
    */

    /**
     * @return static 
     */
    public static function fromJsonMap(array $data)
    {
        return (new static())
            -> setLikeCount((string) $data[self::KEY_LIKE_COUNT])
            -> setCommentCount((string) $data[self::KEY_COMMENT_COUNT])
            -> setFollowCount((string) $data[self::KEY_FOLLOW_COUNT])
            -> setOtherCount((string) $data[self::KEY_OTHER_COUNT]);
    }

    /*
    |--------------------------------------------------------------------------
    | serialization for json_encode
    |--------------------------------------------------------------------------
    */

    public function jsonSerialize()
    {
        return array(
            self::KEY_LIKE_COUNT         => $this -> likeCount,
            self::KEY_COMMENT_COUNT      => $this -> commentCount,
            self::KEY_FOLLOW_COUNT       => $this -> followCount,
            self::KEY_OTHER_COUNT        => $this -> otherCount,
        );
    }

    /*
    |--------------------------------------------------------------------------
    | implement DTO methods
    |--------------------------------------------------------------------------
    */

    /**
     * @param NotificationsCountDTO $notificationsCountDTO
     */
    public static function serialize($notificationsCountDTO): string
    {
        return \json_encode($notificationsCountDTO);
    }

    /**
     * @return NotificationsCountDTO
     */
    public static function deSerialize(string $notificationsCountDTO)
    {
        $data = \json_decode($notificationsCountDTO, true);

        return static::fromJsonMap($data);
    }
}
